

/****
 * IEC 61131-3 standard function block library
 */

/* NOTE: The code in this file was generated by iec2c (i.e. matiec C compiler), using as source
 *        the *.txt files in the 'lib' directory.
 *       The only 'manual' change was:
 *          - to merge the generated .h and .c files into this single file
 *          - to remove the forward declarations of the functions
 *          - to change the function prototypes to become 'static'.
 *             e.g.:   static void R_TRIG_init__(...)
 *                     ^^^^^^
 * 
 * NOTE: If the structure of the C code generated by iec2c (matiec) should change, then this C 'library'
 *       file will need to be recompiled. 
 *       The correct way of going about this would be to have this file be automatically generated during
 *       the build process (i.e. after compiling matiec), but we will leave this for later if it ever
 *       becomes necessary.
 * 
 * WARNING: There are 2 versions of this file:
 *            - file: iec_std_FB.h
 *              Version to be used when the EN and ENO parameters are implicitly generated
 *              for all functions and function blocks
 *            - file: iec_std_FB_no_ENENO.h
 *              Version to be used when the EN and ENO parameters are NOT implicitly generated
 *              for all functions and function blocks
 */

#ifndef _IEC_STD_FB_H
#define _IEC_STD_FB_H


#include "accessor.h"



// FUNCTION_BLOCK R_TRIG
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CLK)
  __DECLARE_VAR(BOOL,Q)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,M)

} R_TRIG;

// FUNCTION_BLOCK F_TRIG
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CLK)
  __DECLARE_VAR(BOOL,Q)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,M)

} F_TRIG;

// FUNCTION_BLOCK SR
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,S1)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(BOOL,Q1)

  // FB private variables - TEMP, private and located variables

} SR;

// FUNCTION_BLOCK RS
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,S)
  __DECLARE_VAR(BOOL,R1)
  __DECLARE_VAR(BOOL,Q1)

  // FB private variables - TEMP, private and located variables

} RS;

// FUNCTION_BLOCK CTU
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(INT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(INT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CU_T;

} CTU;

// FUNCTION_BLOCK CTU_DINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(DINT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(DINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CU_T;

} CTU_DINT;

// FUNCTION_BLOCK CTU_LINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(LINT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(LINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CU_T;

} CTU_LINT;

// FUNCTION_BLOCK CTU_UDINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(UDINT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(UDINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CU_T;

} CTU_UDINT;

// FUNCTION_BLOCK CTU_ULINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(ULINT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(ULINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CU_T;

} CTU_ULINT;

// FUNCTION_BLOCK CTD
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(INT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(INT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;

} CTD;

// FUNCTION_BLOCK CTD_DINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(DINT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(DINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;

} CTD_DINT;

// FUNCTION_BLOCK CTD_LINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(LINT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(LINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;

} CTD_LINT;

// FUNCTION_BLOCK CTD_UDINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(UDINT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(UDINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;

} CTD_UDINT;

// FUNCTION_BLOCK CTD_ULINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(ULINT,PV)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(ULINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;

} CTD_ULINT;

// FUNCTION_BLOCK CTUD
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(INT,PV)
  __DECLARE_VAR(BOOL,QU)
  __DECLARE_VAR(BOOL,QD)
  __DECLARE_VAR(INT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;
  R_TRIG CU_T;

} CTUD;

// FUNCTION_BLOCK CTUD_DINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(DINT,PV)
  __DECLARE_VAR(BOOL,QU)
  __DECLARE_VAR(BOOL,QD)
  __DECLARE_VAR(DINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;
  R_TRIG CU_T;

} CTUD_DINT;

// FUNCTION_BLOCK CTUD_LINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(LINT,PV)
  __DECLARE_VAR(BOOL,QU)
  __DECLARE_VAR(BOOL,QD)
  __DECLARE_VAR(LINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;
  R_TRIG CU_T;

} CTUD_LINT;

// FUNCTION_BLOCK CTUD_UDINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(UDINT,PV)
  __DECLARE_VAR(BOOL,QU)
  __DECLARE_VAR(BOOL,QD)
  __DECLARE_VAR(UDINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;
  R_TRIG CU_T;

} CTUD_UDINT;

// FUNCTION_BLOCK CTUD_ULINT
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CU)
  __DECLARE_VAR(BOOL,CD)
  __DECLARE_VAR(BOOL,R)
  __DECLARE_VAR(BOOL,LD)
  __DECLARE_VAR(ULINT,PV)
  __DECLARE_VAR(BOOL,QU)
  __DECLARE_VAR(BOOL,QD)
  __DECLARE_VAR(ULINT,CV)

  // FB private variables - TEMP, private and located variables
  R_TRIG CD_T;
  R_TRIG CU_T;

} CTUD_ULINT;

// FUNCTION_BLOCK TP
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,IN)
  __DECLARE_VAR(TIME,PT)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(TIME,ET)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(SINT,STATE)
  __DECLARE_VAR(BOOL,PREV_IN)
  __DECLARE_VAR(TIME,CURRENT_TIME)
  __DECLARE_VAR(TIME,START_TIME)

} TP;

// FUNCTION_BLOCK TON
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,IN)
  __DECLARE_VAR(TIME,PT)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(TIME,ET)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(SINT,STATE)
  __DECLARE_VAR(BOOL,PREV_IN)
  __DECLARE_VAR(TIME,CURRENT_TIME)
  __DECLARE_VAR(TIME,START_TIME)

} TON;

// FUNCTION_BLOCK TOF
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,IN)
  __DECLARE_VAR(TIME,PT)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(TIME,ET)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(SINT,STATE)
  __DECLARE_VAR(BOOL,PREV_IN)
  __DECLARE_VAR(TIME,CURRENT_TIME)
  __DECLARE_VAR(TIME,START_TIME)

} TOF;

// FUNCTION_BLOCK DERIVATIVE
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,RUN)
  __DECLARE_VAR(REAL,XIN)
  __DECLARE_VAR(TIME,CYCLE)
  __DECLARE_VAR(REAL,XOUT)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,X1)
  __DECLARE_VAR(REAL,X2)
  __DECLARE_VAR(REAL,X3)

} DERIVATIVE;

// FUNCTION_BLOCK HYSTERESIS
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(REAL,XIN1)
  __DECLARE_VAR(REAL,XIN2)
  __DECLARE_VAR(REAL,EPS)
  __DECLARE_VAR(BOOL,Q)

  // FB private variables - TEMP, private and located variables

} HYSTERESIS;

// FUNCTION_BLOCK INTEGRAL
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,RUN)
  __DECLARE_VAR(BOOL,R1)
  __DECLARE_VAR(REAL,XIN)
  __DECLARE_VAR(REAL,X0)
  __DECLARE_VAR(TIME,CYCLE)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(REAL,XOUT)

  // FB private variables - TEMP, private and located variables

} INTEGRAL;

// FUNCTION_BLOCK PID
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,AUTO)
  __DECLARE_VAR(REAL,PV)
  __DECLARE_VAR(REAL,SP)
  __DECLARE_VAR(REAL,X0)
  __DECLARE_VAR(REAL,KP)
  __DECLARE_VAR(REAL,TR)
  __DECLARE_VAR(REAL,TD)
  __DECLARE_VAR(TIME,CYCLE)
  __DECLARE_VAR(REAL,XOUT)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,ERROR)
  INTEGRAL ITERM;
  DERIVATIVE DTERM;

} PID;

// FUNCTION_BLOCK RAMP
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,RUN)
  __DECLARE_VAR(REAL,X0)
  __DECLARE_VAR(REAL,X1)
  __DECLARE_VAR(TIME,TR)
  __DECLARE_VAR(TIME,CYCLE)
  __DECLARE_VAR(BOOL,BUSY)
  __DECLARE_VAR(REAL,XOUT)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(REAL,XI)
  __DECLARE_VAR(TIME,T)

} RAMP;

// FUNCTION_BLOCK RTC
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,IN)
  __DECLARE_VAR(DT,PDT)
  __DECLARE_VAR(BOOL,Q)
  __DECLARE_VAR(DT,CDT)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,PREV_IN)
  __DECLARE_VAR(TIME,OFFSET)
  __DECLARE_VAR(DT,CURRENT_TIME)

} RTC;

// FUNCTION_BLOCK SEMA
// Data part
typedef struct {
  // FB Interface - IN, OUT, IN_OUT variables
  __DECLARE_VAR(BOOL,EN)
  __DECLARE_VAR(BOOL,ENO)
  __DECLARE_VAR(BOOL,CLAIM)
  __DECLARE_VAR(BOOL,RELEASE)
  __DECLARE_VAR(BOOL,BUSY)

  // FB private variables - TEMP, private and located variables
  __DECLARE_VAR(BOOL,Q_INTERNAL)

} SEMA;




static void R_TRIG_init__(R_TRIG *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CLK,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->M,__BOOL_LITERAL(FALSE),1)
}

// Code part
static void R_TRIG_body__(R_TRIG *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CLK,) && !(__GET_VAR(data__->M,))));
  __SET_VAR(data__->,M,,__GET_VAR(data__->CLK,));

  goto __end;

__end:
  return;
} // R_TRIG_body__() 





static void F_TRIG_init__(F_TRIG *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CLK,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->M,__BOOL_LITERAL(TRUE),retain)
}

// Code part
static void F_TRIG_body__(F_TRIG *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->,Q,,(!(__GET_VAR(data__->CLK,)) && !(__GET_VAR(data__->M,))));
  __SET_VAR(data__->,M,,!(__GET_VAR(data__->CLK,)));

  goto __end;

__end:
  return;
} // F_TRIG_body__() 





static void SR_init__(SR *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->S1,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->Q1,__BOOL_LITERAL(FALSE),retain)
}

// Code part
static void SR_body__(SR *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->,Q1,,(__GET_VAR(data__->S1,) || (!(__GET_VAR(data__->R,)) && __GET_VAR(data__->Q1,))));

  goto __end;

__end:
  return;
} // SR_body__() 





static void RS_init__(RS *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->S,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R1,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->Q1,__BOOL_LITERAL(FALSE),retain)
}

// Code part
static void RS_body__(RS *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->,Q1,,(!(__GET_VAR(data__->R1,)) && (__GET_VAR(data__->S,) || __GET_VAR(data__->Q1,))));

  goto __end;

__end:
  return;
} // RS_body__() 





static void CTU_init__(CTU *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTU_body__(CTU *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));

  goto __end;

__end:
  return;
} // CTU_body__() 





static void CTU_DINT_init__(CTU_DINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTU_DINT_body__(CTU_DINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));

  goto __end;

__end:
  return;
} // CTU_DINT_body__() 





static void CTU_LINT_init__(CTU_LINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTU_LINT_body__(CTU_LINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));

  goto __end;

__end:
  return;
} // CTU_LINT_body__() 





static void CTU_UDINT_init__(CTU_UDINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTU_UDINT_body__(CTU_UDINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));

  goto __end;

__end:
  return;
} // CTU_UDINT_body__() 





static void CTU_ULINT_init__(CTU_ULINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTU_ULINT_body__(CTU_ULINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));

  goto __end;

__end:
  return;
} // CTU_ULINT_body__() 





static void CTD_init__(CTD *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
}

// Code part
static void CTD_body__(CTD *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTD_body__() 





static void CTD_DINT_init__(CTD_DINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
}

// Code part
static void CTD_DINT_body__(CTD_DINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTD_DINT_body__() 





static void CTD_LINT_init__(CTD_LINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
}

// Code part
static void CTD_LINT_body__(CTD_LINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTD_LINT_body__() 





static void CTD_UDINT_init__(CTD_UDINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
}

// Code part
static void CTD_UDINT_body__(CTD_UDINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTD_UDINT_body__() 





static void CTD_ULINT_init__(CTD_ULINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
}

// Code part
static void CTD_ULINT_body__(CTD_ULINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
    __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTD_ULINT_body__() 





static void CTUD_init__(CTUD *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->QU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->QD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTUD_body__(CTUD *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else {
    if (!((__GET_VAR(data__->CU_T.Q,) && __GET_VAR(data__->CD_T.Q,)))) {
      if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
      } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
      };
    };
  };
  __SET_VAR(data__->,QU,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));
  __SET_VAR(data__->,QD,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTUD_body__() 





static void CTUD_DINT_init__(CTUD_DINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->QU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->QD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTUD_DINT_body__(CTUD_DINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else {
    if (!((__GET_VAR(data__->CU_T.Q,) && __GET_VAR(data__->CD_T.Q,)))) {
      if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
      } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
      };
    };
  };
  __SET_VAR(data__->,QU,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));
  __SET_VAR(data__->,QD,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTUD_DINT_body__() 





static void CTUD_LINT_init__(CTUD_LINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->QU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->QD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTUD_LINT_body__(CTUD_LINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else {
    if (!((__GET_VAR(data__->CU_T.Q,) && __GET_VAR(data__->CD_T.Q,)))) {
      if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
      } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
      };
    };
  };
  __SET_VAR(data__->,QU,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));
  __SET_VAR(data__->,QD,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTUD_LINT_body__() 





static void CTUD_UDINT_init__(CTUD_UDINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->QU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->QD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTUD_UDINT_body__(CTUD_UDINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else {
    if (!((__GET_VAR(data__->CU_T.Q,) && __GET_VAR(data__->CD_T.Q,)))) {
      if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
      } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
      };
    };
  };
  __SET_VAR(data__->,QU,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));
  __SET_VAR(data__->,QD,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTUD_UDINT_body__() 





static void CTUD_ULINT_init__(CTUD_ULINT *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->LD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->QU,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->QD,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CV,0,retain)
  R_TRIG_init__(&data__->CD_T,retain);
  R_TRIG_init__(&data__->CU_T,retain);
}

// Code part
static void CTUD_ULINT_body__(CTUD_ULINT *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->CD_T.,CLK,,__GET_VAR(data__->CD,));
  R_TRIG_body__(&data__->CD_T);
  __SET_VAR(data__->CU_T.,CLK,,__GET_VAR(data__->CU,));
  R_TRIG_body__(&data__->CU_T);
  if (__GET_VAR(data__->R,)) {
    __SET_VAR(data__->,CV,,0);
  } else if (__GET_VAR(data__->LD,)) {
    __SET_VAR(data__->,CV,,__GET_VAR(data__->PV,));
  } else {
    if (!((__GET_VAR(data__->CU_T.Q,) && __GET_VAR(data__->CD_T.Q,)))) {
      if ((__GET_VAR(data__->CU_T.Q,) && (__GET_VAR(data__->CV,) < __GET_VAR(data__->PV,)))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) + 1));
      } else if ((__GET_VAR(data__->CD_T.Q,) && (__GET_VAR(data__->CV,) > 0))) {
        __SET_VAR(data__->,CV,,(__GET_VAR(data__->CV,) - 1));
      };
    };
  };
  __SET_VAR(data__->,QU,,(__GET_VAR(data__->CV,) >= __GET_VAR(data__->PV,)));
  __SET_VAR(data__->,QD,,(__GET_VAR(data__->CV,) <= 0));

  goto __end;

__end:
  return;
} // CTUD_ULINT_body__() 





static void TP_init__(TP *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->IN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PT,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->ET,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->STATE,0,retain)
  __INIT_VAR(data__->PREV_IN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CURRENT_TIME,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->START_TIME,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
}

// Code part
static void TP_body__(TP *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  #define GetFbVar(var,...) __GET_VAR(data__->var,__VA_ARGS__)
  #define SetFbVar(var,val,...) __SET_VAR(data__->,var,__VA_ARGS__,val)
__SET_VAR(data__->,CURRENT_TIME,,__CURRENT_TIME)
  #undef GetFbVar
  #undef SetFbVar
;
  if ((((__GET_VAR(data__->STATE,) == 0) && !(__GET_VAR(data__->PREV_IN,))) && __GET_VAR(data__->IN,))) {
    __SET_VAR(data__->,STATE,,1);
    __SET_VAR(data__->,Q,,__BOOL_LITERAL(TRUE));
    __SET_VAR(data__->,START_TIME,,__GET_VAR(data__->CURRENT_TIME,));
  } else if ((__GET_VAR(data__->STATE,) == 1)) {
    if (LE_TIME(__BOOL_LITERAL(TRUE), NULL, 2, __time_add(__GET_VAR(data__->START_TIME,), __GET_VAR(data__->PT,)), __GET_VAR(data__->CURRENT_TIME,))) {
      __SET_VAR(data__->,STATE,,2);
      __SET_VAR(data__->,Q,,__BOOL_LITERAL(FALSE));
      __SET_VAR(data__->,ET,,__GET_VAR(data__->PT,));
    } else {
      __SET_VAR(data__->,ET,,__time_sub(__GET_VAR(data__->CURRENT_TIME,), __GET_VAR(data__->START_TIME,)));
    };
  };
  if (((__GET_VAR(data__->STATE,) == 2) && !(__GET_VAR(data__->IN,)))) {
    __SET_VAR(data__->,ET,,__time_to_timespec(1, 0, 0, 0, 0, 0));
    __SET_VAR(data__->,STATE,,0);
  };
  __SET_VAR(data__->,PREV_IN,,__GET_VAR(data__->IN,));

  goto __end;

__end:
  return;
} // TP_body__() 





static void TON_init__(TON *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->IN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PT,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->ET,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->STATE,0,retain)
  __INIT_VAR(data__->PREV_IN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CURRENT_TIME,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->START_TIME,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
}

// Code part
static void TON_body__(TON *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  #define GetFbVar(var,...) __GET_VAR(data__->var,__VA_ARGS__)
  #define SetFbVar(var,val,...) __SET_VAR(data__->,var,__VA_ARGS__,val)
__SET_VAR(data__->,CURRENT_TIME,,__CURRENT_TIME)
  #undef GetFbVar
  #undef SetFbVar
;
  if ((((__GET_VAR(data__->STATE,) == 0) && !(__GET_VAR(data__->PREV_IN,))) && __GET_VAR(data__->IN,))) {
    __SET_VAR(data__->,STATE,,1);
    __SET_VAR(data__->,Q,,__BOOL_LITERAL(FALSE));
    __SET_VAR(data__->,START_TIME,,__GET_VAR(data__->CURRENT_TIME,));
  } else {
    if (!(__GET_VAR(data__->IN,))) {
      __SET_VAR(data__->,ET,,__time_to_timespec(1, 0, 0, 0, 0, 0));
      __SET_VAR(data__->,Q,,__BOOL_LITERAL(FALSE));
      __SET_VAR(data__->,STATE,,0);
    } else if ((__GET_VAR(data__->STATE,) == 1)) {
      if (LE_TIME(__BOOL_LITERAL(TRUE), NULL, 2, __time_add(__GET_VAR(data__->START_TIME,), __GET_VAR(data__->PT,)), __GET_VAR(data__->CURRENT_TIME,))) {
        __SET_VAR(data__->,STATE,,2);
        __SET_VAR(data__->,Q,,__BOOL_LITERAL(TRUE));
        __SET_VAR(data__->,ET,,__GET_VAR(data__->PT,));
      } else {
        __SET_VAR(data__->,ET,,__time_sub(__GET_VAR(data__->CURRENT_TIME,), __GET_VAR(data__->START_TIME,)));
      };
    };
  };
  __SET_VAR(data__->,PREV_IN,,__GET_VAR(data__->IN,));

  goto __end;

__end:
  return;
} // TON_body__() 





static void TOF_init__(TOF *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->IN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PT,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->ET,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->STATE,0,retain)
  __INIT_VAR(data__->PREV_IN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CURRENT_TIME,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->START_TIME,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
}

// Code part
static void TOF_body__(TOF *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  #define GetFbVar(var,...) __GET_VAR(data__->var,__VA_ARGS__)
  #define SetFbVar(var,val,...) __SET_VAR(data__->,var,__VA_ARGS__,val)
__SET_VAR(data__->,CURRENT_TIME,,__CURRENT_TIME)
  #undef GetFbVar
  #undef SetFbVar
;
  if ((((__GET_VAR(data__->STATE,) == 0) && __GET_VAR(data__->PREV_IN,)) && !(__GET_VAR(data__->IN,)))) {
    __SET_VAR(data__->,STATE,,1);
    __SET_VAR(data__->,START_TIME,,__GET_VAR(data__->CURRENT_TIME,));
  } else {
    if (__GET_VAR(data__->IN,)) {
      __SET_VAR(data__->,ET,,__time_to_timespec(1, 0, 0, 0, 0, 0));
      __SET_VAR(data__->,STATE,,0);
    } else if ((__GET_VAR(data__->STATE,) == 1)) {
      if (LE_TIME(__BOOL_LITERAL(TRUE), NULL, 2, __time_add(__GET_VAR(data__->START_TIME,), __GET_VAR(data__->PT,)), __GET_VAR(data__->CURRENT_TIME,))) {
        __SET_VAR(data__->,STATE,,2);
        __SET_VAR(data__->,ET,,__GET_VAR(data__->PT,));
      } else {
        __SET_VAR(data__->,ET,,__time_sub(__GET_VAR(data__->CURRENT_TIME,), __GET_VAR(data__->START_TIME,)));
      };
    };
  };
  __SET_VAR(data__->,Q,,(__GET_VAR(data__->IN,) || (__GET_VAR(data__->STATE,) == 1)));
  __SET_VAR(data__->,PREV_IN,,__GET_VAR(data__->IN,));

  goto __end;

__end:
  return;
} // TOF_body__() 





static void DERIVATIVE_init__(DERIVATIVE *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->RUN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->XIN,0,retain)
  __INIT_VAR(data__->CYCLE,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->XOUT,0,retain)
  __INIT_VAR(data__->X1,0,retain)
  __INIT_VAR(data__->X2,0,retain)
  __INIT_VAR(data__->X3,0,retain)
}

// Code part
static void DERIVATIVE_body__(DERIVATIVE *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  if (__GET_VAR(data__->RUN,)) {
    __SET_VAR(data__->,XOUT,,((((3.0 * (__GET_VAR(data__->XIN,) - __GET_VAR(data__->X3,))) + __GET_VAR(data__->X1,)) - __GET_VAR(data__->X2,)) / (10.0 * TIME_TO_REAL((BOOL)__BOOL_LITERAL(TRUE),
      NULL,
      (TIME)__GET_VAR(data__->CYCLE,)))));
    __SET_VAR(data__->,X3,,__GET_VAR(data__->X2,));
    __SET_VAR(data__->,X2,,__GET_VAR(data__->X1,));
    __SET_VAR(data__->,X1,,__GET_VAR(data__->XIN,));
  } else {
    __SET_VAR(data__->,XOUT,,0.0);
    __SET_VAR(data__->,X1,,__GET_VAR(data__->XIN,));
    __SET_VAR(data__->,X2,,__GET_VAR(data__->XIN,));
    __SET_VAR(data__->,X3,,__GET_VAR(data__->XIN,));
  };

  goto __end;

__end:
  return;
} // DERIVATIVE_body__() 





static void HYSTERESIS_init__(HYSTERESIS *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->XIN1,0,retain)
  __INIT_VAR(data__->XIN2,0,retain)
  __INIT_VAR(data__->EPS,0,retain)
  __INIT_VAR(data__->Q,0,retain)
}

// Code part
static void HYSTERESIS_body__(HYSTERESIS *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  if (__GET_VAR(data__->Q,)) {
    if ((__GET_VAR(data__->XIN1,) < (__GET_VAR(data__->XIN2,) - __GET_VAR(data__->EPS,)))) {
      __SET_VAR(data__->,Q,,0);
    };
  } else if ((__GET_VAR(data__->XIN1,) > (__GET_VAR(data__->XIN2,) + __GET_VAR(data__->EPS,)))) {
    __SET_VAR(data__->,Q,,1);
  };

  goto __end;

__end:
  return;
} // HYSTERESIS_body__() 





static void INTEGRAL_init__(INTEGRAL *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->RUN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->R1,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->XIN,0,retain)
  __INIT_VAR(data__->X0,0,retain)
  __INIT_VAR(data__->CYCLE,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->XOUT,0,retain)
}

// Code part
static void INTEGRAL_body__(INTEGRAL *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->,Q,,!(__GET_VAR(data__->R1,)));
  if (__GET_VAR(data__->R1,)) {
    __SET_VAR(data__->,XOUT,,__GET_VAR(data__->X0,));
  } else if (__GET_VAR(data__->RUN,)) {
    __SET_VAR(data__->,XOUT,,(__GET_VAR(data__->XOUT,) + (__GET_VAR(data__->XIN,) * TIME_TO_REAL((BOOL)__BOOL_LITERAL(TRUE),
      NULL,
      (TIME)__GET_VAR(data__->CYCLE,)))));
  };

  goto __end;

__end:
  return;
} // INTEGRAL_body__() 





static void PID_init__(PID *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->AUTO,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PV,0,retain)
  __INIT_VAR(data__->SP,0,retain)
  __INIT_VAR(data__->X0,0,retain)
  __INIT_VAR(data__->KP,0,retain)
  __INIT_VAR(data__->TR,0,retain)
  __INIT_VAR(data__->TD,0,retain)
  __INIT_VAR(data__->CYCLE,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->XOUT,0,retain)
  __INIT_VAR(data__->ERROR,0,retain)
  INTEGRAL_init__(&data__->ITERM,retain);
  DERIVATIVE_init__(&data__->DTERM,retain);
}

// Code part
static void PID_body__(PID *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->,ERROR,,(__GET_VAR(data__->PV,) - __GET_VAR(data__->SP,)));
  __SET_VAR(data__->ITERM.,RUN,,__GET_VAR(data__->AUTO,));
  __SET_VAR(data__->ITERM.,R1,,!(__GET_VAR(data__->AUTO,)));
  __SET_VAR(data__->ITERM.,XIN,,__GET_VAR(data__->ERROR,));
  __SET_VAR(data__->ITERM.,X0,,(__GET_VAR(data__->TR,) * (__GET_VAR(data__->X0,) - __GET_VAR(data__->ERROR,))));
  __SET_VAR(data__->ITERM.,CYCLE,,__GET_VAR(data__->CYCLE,));
  INTEGRAL_body__(&data__->ITERM);
  __SET_VAR(data__->DTERM.,RUN,,__GET_VAR(data__->AUTO,));
  __SET_VAR(data__->DTERM.,XIN,,__GET_VAR(data__->ERROR,));
  __SET_VAR(data__->DTERM.,CYCLE,,__GET_VAR(data__->CYCLE,));
  DERIVATIVE_body__(&data__->DTERM);
  __SET_VAR(data__->,XOUT,,(__GET_VAR(data__->KP,) * ((__GET_VAR(data__->ERROR,) + (__GET_VAR(data__->ITERM.XOUT,) / __GET_VAR(data__->TR,))) + (__GET_VAR(data__->DTERM.XOUT,) * __GET_VAR(data__->TD,)))));

  goto __end;

__end:
  return;
} // PID_body__() 





static void RAMP_init__(RAMP *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->RUN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->X0,0,retain)
  __INIT_VAR(data__->X1,0,retain)
  __INIT_VAR(data__->TR,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->CYCLE,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->BUSY,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->XOUT,0.0,retain)
  __INIT_VAR(data__->XI,0,retain)
  __INIT_VAR(data__->T,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
}

// Code part
static void RAMP_body__(RAMP *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->,BUSY,,__GET_VAR(data__->RUN,));
  if (__GET_VAR(data__->RUN,)) {
    if (GE_TIME(__BOOL_LITERAL(TRUE), NULL, 2, __GET_VAR(data__->T,), __GET_VAR(data__->TR,))) {
      __SET_VAR(data__->,BUSY,,0);
      __SET_VAR(data__->,XOUT,,__GET_VAR(data__->X1,));
    } else {
      __SET_VAR(data__->,XOUT,,(__GET_VAR(data__->XI,) + (((__GET_VAR(data__->X1,) - __GET_VAR(data__->XI,)) * TIME_TO_REAL((BOOL)__BOOL_LITERAL(TRUE),
        NULL,
        (TIME)__GET_VAR(data__->T,))) / TIME_TO_REAL((BOOL)__BOOL_LITERAL(TRUE),
        NULL,
        (TIME)__GET_VAR(data__->TR,)))));
      __SET_VAR(data__->,T,,__time_add(__GET_VAR(data__->T,), __GET_VAR(data__->CYCLE,)));
    };
  } else {
    __SET_VAR(data__->,XOUT,,__GET_VAR(data__->X0,));
    __SET_VAR(data__->,XI,,__GET_VAR(data__->X0,));
    __SET_VAR(data__->,T,,__time_to_timespec(1, 0, 0, 0, 0, 0));
  };

  goto __end;

__end:
  return;
} // RAMP_body__() 





static void RTC_init__(RTC *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->IN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->PDT,__dt_to_timespec(0, 0, 0, 1, 1, 1970),retain)
  __INIT_VAR(data__->Q,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->CDT,__dt_to_timespec(0, 0, 0, 1, 1, 1970),retain)
  __INIT_VAR(data__->PREV_IN,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->OFFSET,__time_to_timespec(1, 0, 0, 0, 0, 0),retain)
  __INIT_VAR(data__->CURRENT_TIME,__dt_to_timespec(0, 0, 0, 1, 1, 1970),retain)
}

// Code part
static void RTC_body__(RTC *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  #define GetFbVar(var,...) __GET_VAR(data__->var,__VA_ARGS__)
  #define SetFbVar(var,val,...) __SET_VAR(data__->,var,__VA_ARGS__,val)
__SET_VAR(data__->,CURRENT_TIME,,__CURRENT_TIME)
  #undef GetFbVar
  #undef SetFbVar
;
  if (__GET_VAR(data__->IN,)) {
    if (!(__GET_VAR(data__->PREV_IN,))) {
      __SET_VAR(data__->,OFFSET,,__time_sub(__GET_VAR(data__->PDT,), __GET_VAR(data__->CURRENT_TIME,)));
    };
    __SET_VAR(data__->,CDT,,__time_add(__GET_VAR(data__->CURRENT_TIME,), __GET_VAR(data__->OFFSET,)));
  } else {
    __SET_VAR(data__->,CDT,,__GET_VAR(data__->CURRENT_TIME,));
  };
  __SET_VAR(data__->,Q,,__GET_VAR(data__->IN,));
  __SET_VAR(data__->,PREV_IN,,__GET_VAR(data__->IN,));

  goto __end;

__end:
  return;
} // RTC_body__() 





static void SEMA_init__(SEMA *data__, BOOL retain) {
  __INIT_VAR(data__->EN,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->ENO,__BOOL_LITERAL(TRUE),retain)
  __INIT_VAR(data__->CLAIM,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->RELEASE,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->BUSY,__BOOL_LITERAL(FALSE),retain)
  __INIT_VAR(data__->Q_INTERNAL,__BOOL_LITERAL(FALSE),retain)
}

// Code part
static void SEMA_body__(SEMA *data__) {
  // Control execution
  if (!__GET_VAR(data__->EN)) {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(FALSE));
    return;
  }
  else {
    __SET_VAR(data__->,ENO,,__BOOL_LITERAL(TRUE));
  }
  // Initialise TEMP variables

  __SET_VAR(data__->,Q_INTERNAL,,(__GET_VAR(data__->CLAIM,) || (__GET_VAR(data__->Q_INTERNAL,) && !(__GET_VAR(data__->RELEASE,)))));
  __SET_VAR(data__->,BUSY,,__GET_VAR(data__->Q_INTERNAL,));

  goto __end;

__end:
  return;
} // SEMA_body__() 


#include "arduino_lib_FB.h"
#include "p1am_FB.h"
#include "stm32.h"
#include "MQTT.h"
#include "sm_cards.h"
#include "jaguar.h"
#include "SL-RP4.h"
#endif //_IEC_STD_FB_H
